<?php

namespace Illuminate\Contracts\Auth;

interface MustBackUpSecretPhrase
{
    /**
     * Determine if the user has backed up their secret phrase.
     *
     * @return bool
     */
    public function hasBackedUpSecretPhrase();

    /**
     * Mark the given user's secret phrase as backed up.
     *
     * @return bool
     */
    public function markSecretPhraseAsBackedUp();
}
