<?php

namespace Illuminate\Contracts\Auth;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Contracts\Auth\StatefulGuard;
use Illuminate\Contracts\Auth\Authenticatable;

/**
 * @method Guard|StatefulGuard guard(string|null $name = null) Get a guard instance by name.
 * @method void shouldUse(string $name) Set the default guard the factory should serve.
 * @method bool check() Determine if the user is authenticated.
 * @method bool guest() Determine if the current user is a guest.
 * @method Authenticatable|null user() Get the currently authenticated user.
 * @method int|string|null id() Get the ID of the currently authenticated user.
 * @method bool attempt(array $credentials = [], bool $remember = false) Attempt to authenticate a user using the given credentials.
 * @method bool once(array $credentials = []) Log a user into the application without sessions or cookies.
 * @method void login(Authenticatable $user, bool $remember = false) Log the given user into the application.
 * @method bool viaRemember() Determine if the user was authenticated via "remember me" cookie.
 * @method bool loginUsingId() Login user in using an ID.
 * @method void logout() Log the user out of the application.
 */
interface Factory
{
    /**
     * Get a guard instance by name.
     *
     * @param  string|null  $name
     * @return \Illuminate\Contracts\Auth\Guard|\Illuminate\Contracts\Auth\StatefulGuard
     */
    public function guard($name = null);

    /**
     * Set the default guard the factory should serve.
     *
     * @param  string  $name
     * @return void
     */
    public function shouldUse($name);
}
