<?php

namespace Illuminate\Auth;

trait MustBackUpSecretPhrase
{
    /**
     * Determine if the user has backed up their secret phrase.
     *
     * @return bool
     */
    public function hasBackedUpSecretPhrase()
    {
        return ! is_null($this->secret_phrase_verified_at); 
    }

    /**
     * Mark the given user's secret phrase as backed up.
     *
     * @return bool
     */
    public function markSecretPhraseAsBackedUp()
    {
        return $this->forceFill([
            'secret_phrase_verified_at' => $this->freshTimestamp(),
        ])->save();
    }
}
