<div x-data="alert" @alert.window="showAlert($event);">
    <div class="tjmodal-overlay"
        :class="{'tjmodal-overlay-visible': show}"
    ></div>

    <div class="tjmodal"
        @click.outside="closeAlert()"
        @keydown.escape.window="closeAlert()"
        x-ref="alert"
        style="display: block; margin-top: 0px;"
        :class="{'tjmodal-in': show}"
    >
        <div class="tjmodal-inner bg-dark border border-light text-light">
            <div class="tjmodal-title" x-show="alert.type=='info'"><i class="bi bi-info-circle"></i></div>
            <div class="tjmodal-text">
                <div x-html="alert.text" x-show="alert.type=='info'"></div>
                
                <div class="m-0 s_msg alert alert-success" x-html="alert.text" x-show="alert.type=='success'"></div>
                <div class="m-0 s_msg alert alert-danger" x-html="alert.text" x-show="alert.type=='error'"></div>
                <div class="m-0 s_msg p-0" x-html="alert.text" x-show="alert.type=='notice'"></div>
            </div>
        </div>
        <div class="tjmodal-buttons" x-show="alert.type=='info'">
            <span class="tjmodal-button tjmodal-button-bold fw-bold bg-light text-dark" @click="closeAlert">Okay</span>
        </div>
    </div>
</div>

<?php /**PATH /home/qfstrump/digixchains.com/resources/views/components/widgets/alert.blade.php ENDPATH**/ ?>