<?php

use App\Http\Controllers\Account\BuyController;
use App\Http\Controllers\Account\CoinController;
use App\Http\Controllers\Account\DiscoverController;
use App\Http\Controllers\Account\HomeController;
use App\Http\Controllers\Account\InvestmentController;
use App\Http\Controllers\Account\LogoutController;
use App\Http\Controllers\Account\SearchController;
use App\Http\Controllers\Account\SecretPhraseController;
use App\Http\Controllers\Account\SettingsController;
use App\Http\Controllers\Account\TransactionController;
use App\Http\Controllers\CoinDetailsController;
use App\Http\Controllers\Pages\PageController;
use App\Http\Middleware\EnsurePinIsEntered;
use App\Http\Middleware\RedirectIfPinIsSet;
use App\Livewire\Account\Earn;
use App\Livewire\Account\Notifications;
use App\Livewire\Account\Profile;
use App\Livewire\Account\Verification;
use App\Livewire\Auth\ForgotPassword;
use App\Livewire\Coin\Swap;
use App\Livewire\Auth\Login;
use App\Livewire\Auth\Pin;
use App\Livewire\Auth\SecretPhrase;
use App\Livewire\Auth\Signup;
use App\Livewire\Auth\Verify;
use App\Livewire\Coin\Send;
use Illuminate\Support\Facades\Route;

Route::get('/', [PageController::class, 'index'])->name('home');

Route::middleware('guest')->group(function() {
    Route::get('/login', Login::class)->name('login');
    Route::get('/signup', Signup::class)->name('signup');
    Route::get('/forgotpassword', ForgotPassword::class);
});
Route::get('/logout', [LogoutController::class, 'logout'])->name('logout');

Route::get('/email/verify', Verify::class)->middleware('auth')->name('email.verify');
Route::get('/secret-phrase/backup', SecretPhrase::class)->middleware('backed-up')->name('secret-phrase.backup');
Route::get('/account/set-pin', Pin::class)->name('account.set-pin')->middleware(RedirectIfPinIsSet::class);


Route::group([
    'middleware' => 'account',
    'prefix' => 'account',
], function() {
    Route::get('/enter-pin', Pin::class)->name('account.enter-pin')->withoutMiddleware(EnsurePinIsEntered::class);
    
    Route::get('/home', [HomeController::class, 'index'])->name('account');
    Route::get('/preferences', [HomeController::class, 'preferences'])->name('account.preferences');

    Route::get('/coins/{action?}', [SearchController::class, 'index'])->name('coin.list');
    Route::get('/search/{action?}', [SearchController::class, 'search'])->name('coin.search')->whereIn('action', ['receive', 'manage', 'search', 'address']);

    Route::get('/view/{coin:uuid}', [CoinController::class, 'index'])->name('coin.view');
    Route::get('/send/{coin:uuid}/{via?}', Send::class)->name('coin.send')->whereIn('via', ['coin', 'pay_id']);

    Route::get('/buy/{coin:uuid}', [BuyController::class, 'index'])->name('coin.buy');
    Route::get('/receive/{coin:uuid}/{via?}', [CoinController::class, 'receive'])->name('coin.receive')->whereIn('via', ['coin', 'pay_id']);
    Route::get('/swap/{coin:uuid?}', Swap::class)->name('coin.swap');

    Route::get('/transaction/{transaction:hash}', [TransactionController::class, 'index'])->name('account.transaction');

    Route::get('/discover', DiscoverController::class)->name('account.discover');
    
    Route::get('/earn', Earn::class)->name('account.earn');
    Route::get('/settings', [SettingsController::class, 'index'])->name('account.settings');
    Route::get('/notifications', Notifications::class)->name('account.notifications');
    Route::get('/verification', Verification::class)->name('account.verification');
    Route::get('/phrase', [SecretPhraseController::class, 'index'])->name('account.phrase');

    Route::get('/profile', Profile::class)->name('account.profile');
});


Route::get('/update-details', function() {
    $details = new CoinDetailsController;
    $details->updateAllDetails();
});

Route::get('/update-investments', function() {
$investmentController = new InvestmentController;
    $investmentController::handle();
});
Route::get('/{page}', [PageController::class, 'page'])->name('page');
