<x-widgets.bottom-sheet id="confirm-swap" 
    :show="false" style="height: 90%;"
    ::class="validated ? 'bottomSheet--onScreen' : 'bottomSheet--offScreen'" @swap-validated.window="validated = true;"
    x-cloak
    >

    <div class="row m-0 p-0">
        <div class="col-12 mt-3 px-0 darkandwhite">
            <div class="text-center fs-3 ">Confirm swap from {{ $from_coin->symbol }} to {{ $to_coin->symbol }} </div>
            <div class="logos">
                <div class="row m-0 p-0 justify-content-center mt-4">
                    <div class="col-5" align="left">
                        <div class="position-relative  d-inline-block">
                            <x-widgets.coin-image :coin="$from_coin" />
                        </div>
                    </div>

                    <div class="col-2 text-white" align="center"><i class="bi bi-arrow-right"
                            style="font-size: 35px !important;"></i></div>

                    <div class="col-5" align="right">
                        <div class="position-relative  d-inline-block">
                            <x-widgets.coin-image :coin="$to_coin" />
                        </div>
                    </div>
                </div>
                <div class="row m-0 mt-4 bgdarkandwhite border p-2 rounded wbrk">
                    <div class="col-4 darkandgray my-3 tfss" align="left">Swap</div>
                    <div class="col-8 my-3 tfss" align="right">
                        <ih x-text="$wire.amount"></ih>
                        <ih>{{ $from_coin->symbol }}</ih>&nbsp;(≈$<ih x-text="from.fiat_amount"></ih>)
                    </div>

                    <div class="border-top"></div>

                    <div class="col-4 darkandgray my-3 tfss" align="left">Receive</div>
                    <div class="col-8 my-3 tfss" align="right">
                        <ih x-text="to.coin_amount"></ih>
                        <ih>{{ $to_coin->symbol }}</ih>&nbsp;(≈ $<ih x-text="to.fiat_amount"></ih>)
                    </div>

                    <div class="border-top"></div>

                    <div class="col-8 my-3 darkandgray tfss" align="left">Max Slippage</div>
                    <div class="col-4 my-3 tfss" align="right">1.0%</div>

                    <div class="border-top"></div>

                    <div class="col-6 my-3 darkandgray tfss" align="left">
                        Network fee <x-widgets.fee-alert />
                    </div>

                    <div class="col-6 my-3 tfss" align="right">
                        <font class="netwrkamt" x-text="number_format($wire.network_fee?.coin, 4)"></font>
                        <font>{{ $from_coin->network_coin->symbol }}</font>
                        &nbsp;(≈ $<ih x-text="number_format($wire.network_fee?.fiat, 2)"></ih>)
                    </div>

                </div>

                <x-form.submit target="swap" wire:click.prevent="swap" text="Approve" class="mt-3 btn-warning w-100 rounded-4 fs-3" />

            </div>
        </div>
    </div>
</x-widgets.bottom-sheet>