<div class="row justify-content-center p-3 mt-0 mb-2 mx-0 bg-traparent" align="center">
    <div class="col-12 mx-0 px-0">
        <ul class="nav nav-tabs nav-underline justify-content-center border-bottom mb-2" id="myTab"
            role="tablist">
            <li class="nav-item" role="presentation" style="padding-right: 100px">
                <a class="nav-link noload tuh active font-bold fs-5 darkandwhite border-top-0 border-start-0 border-end-0"
                    id="crypto-tab" 
                    data-bs-toggle="tab" 
                    data-bs-target="#crypto-tab-pane" 
                    role="tab"
                    aria-controls="crypto-tab-pane" 
                    aria-selected="false" 
                    aria-current="page"
                    href="#">
                    Transactions
                </a>
            </li>

            <li class="nav-item" role="presentation">
                <a class="nav-link noload tuh fs-5 darkandwhite border-top-0 border-start-0 border-end-0"
                    id="earnings-tab" 
                    data-bs-toggle="tab" 
                    data-bs-target="#earnings-tab-pane" 
                    role="tab"
                    aria-controls="earnings-tab-pane" 
                    aria-selected="false" 
                    aria-current="page"
                    href="#">
                    Earnings
                </a>
            </li>
        </ul>
    </div>

    <div class="w-100"></div>

    <div class="col-12 mx-0 px-0">
        <div class="tab-content px-0" id="myTabContent" align="left">
            <div class="tab-pane fade show active" id="crypto-tab-pane" role="tabpanel" aria-labelledby="crypto-tab" tabindex="0">
                @forelse($coin->user->transactions as $transaction)

                    <x-widgets.transaction-card :$transaction />

                    @empty
                    <div class="col-12 mt-4 px-0 mb-4 mx-0 pt-2 darkandgray tfs" align="center">
                        <i class="bi bi-exclamation-circle" style="font-size: 50px"></i>
                        <br /><br />
                        Transactions will appear here.<br />

                        <a class="mt-3 fw-bold btn btn-warning tuh"
                            href="{{ route('coin.buy', $coin->uuid) }}">
                            Buy {{ $coin->symbol }}
                        </a>

                    </div>
                @endforelse
            </div>
            <div class="tab-pane fade" id="earnings-tab-pane" role="tabpanel" aria-labelledby="earnings-tab" tabindex="0">

                <div class="col-12 mt-4 px-0 mb-4 mx-0 pt-2 darkandgray tfs" align="center">
                    @if(!$coin->plan)
                    <i class="bi bi-exclamation-circle" style="font-size: 50px"></i>
                    <br /><br />
                    Investment earnings is not availble for <b>{{ $coin->symbol }}</b>.<br>
                    @else
                        @forelse($coin->user->investments as $investment)
                            @foreach($investment->earnings as $earning)
                                <x-widgets.earning-card :$earning />
                            @endforeach

                        @empty
                        {{ $coin->full_name }} investment earnings will appear here. <br>
                        @endforelse
                    @endif

                    <a wire:navigate class="mt-3 fw-bold btn btn-warning tuh" href="{{ route('account.earn') }}">
                        Invest in USDT and earn 10% ROI daily
                    </a>
                </div>

            </div>
        </div>
    </div>
</div>