<div x-data="verification" @refresh.window="$wire.$refresh()" wire:ignore.self>
    @if(!$user?->verification?->is_verified)
    <div class="alert alert-warning" align="center">Upload your documents to verify your account.</div>
    <div class="mx-0 mb-4 p-2 rounded bg-transparent tfss">
        <div class="ffoot darkandgray">

            <b class="darkandwhite">ID (front)</b>

            <div class="ttd mb-3 tfs">
                This can be a photo of the front of your: Driving license, National identity card, Passport, Birth
                certificate.
            </div>

            <b class="darkandwhite">ID (back)</b>
            <div class="ttd mb-3 tfs">
                This should be a photo of the back of any above id card you already uploaded
            </div>

            <b class="darkandwhite">Proof of residence</b>

            <div class="ttd tfs">
                This can be your: Water bill, Electricity bill, Telephone bill, Internet bill, Credit card bill or
                Statement, Bank statement.
            </div>
        </div>

    </div>
    @endif
    @if(!$user?->verification?->is_verified)
        @if($user->verification?->proof_of_residence && $user->verification?->id_front && $user->verification?->id_back)
        <div class="row justify-content-center p-3 mt-4 mb-2 mx-3 bgdarkandgray darkandwhite border d-block _pend"
        align="center" style="font-size:20px;">
        <div class="col-12 px-4" align="center"><i class="bi bi-hourglass-split" style="font-size:55px;"></i> <br>Your
            documents has been uploaded, we will review it and notify you via email</div>
    </div>

        @else
        <div id="id-upload" class="mx-0 rounded d-block" align="center" @click="$refs.file.click()">
        <div class="darkandgray p-1 whichid pt-3"><b class="darkandwhite">{{ $convert($active_document) }}</b></div>
        <div class="drop-zone" style="width:200px; height:200px;">
            <div class="drop-zone__prompt ttc ffoot id-form"></div>
            <form method="POST" enctype="multipart/form-data">
                <input type="file" class="d-none" x-ref="file" wire:model.live="file"
                    @change.prevent="validate($event)">
            </form>
        </div>
        <div class="upload-content px-3 darkandgray tfs pb-3">
            <i class="bi bi-person-badge-fill" style="font-size:100px;"></i>
            <div class="mt-4" style="line-height:20px;">
                Drop file here or click to upload
            </div>
        </div>
    </div>
        @endif
    @else
    <div class="row justify-content-center p-3 mt-4 mb-2 mx-3 bgdarkandgray darkandwhite border d-block _pend"
        align="center" style="font-size:20px;">
        <div class="col-12 px-4" align="center"><i class="bi bi-check" style="font-size:55px;"></i> <br>Your KYC has been verified successfully.</div>
    </div>
    @endif
    
    @if(!$user?->verification?->is_verified)
    <div class="proo">
        <div wire:loading class="w-100">
            <x-widgets.loader wire:target="file" />
            <i>Please, wait while your file is uploaded.</i>
        </div>

        @if($user->verification?->proof_of_residence)
        <div class="row border rounded bgdarkandgray mt-4 mx-0">
            <div class="col-2 p-1">
                <i class="bi bi-file-earmark-arrow-up-fill sfa-file-pdf" style="color: #d0b91e !important"></i>
            </div>
            <div class="col-8 p-1 px-3">
                <ih class="ttc">Proof Of Residence</ih>
                <div class="progress">
                    <div class="progress-bar bg-secondary progress-bar-striped progress-bar-animated"
                        style="width:100%; background-color:#d0b91e!important;"></div>
                </div>
            </div>
            <div class="col-2 tfs" style="padding-top: 10px;">
                <i class="bi bi-check-all" style="font-size:25px;color:#f2d30d;"></i>
            </div>
        </div>
        @endif
        @if($user->verification?->id_back)
        <div class="row border rounded bgdarkandgray mt-4 mx-0">
            <div class="col-2 p-1">
                <i class="bi bi-file-earmark-arrow-up-fill sfa-file-pdf" style="color: #d0b91e !important"></i>
            </div>
            <div class="col-8 p-1 px-3">
                <ih class="ttc">ID (Back)</ih>
                <div class="progress">
                    <div class="progress-bar bg-secondary progress-bar-striped progress-bar-animated"
                        style="width:100%; background-color:#d0b91e!important;"></div>
                </div>
            </div>
            <div class="col-2 tfs" style="padding-top: 10px;">
                <i class="bi bi-check-all" style="font-size:25px;color:#f2d30d;"></i>
            </div>
        </div>
        @endif
        @if($user->verification?->id_front)
        <div class="row border rounded bgdarkandgray mt-4 mx-0">
            <div class="col-2 p-1">
                <i class="bi bi-file-earmark-arrow-up-fill sfa-file-pdf" style="color: #d0b91e !important"></i>
            </div>
            <div class="col-8 p-1 px-3">
                <ih class="ttc">ID (Front)</ih>
                <div class="progress">
                    <div class="progress-bar bg-secondary progress-bar-striped progress-bar-animated"
                        style="width:100%; background-color:#d0b91e!important;"></div>
                </div>
            </div>
            <div class="col-2 tfs" style="padding-top: 10px;">
                <i class="bi bi-check-all" style="font-size:25px;color:#f2d30d;"></i>
            </div>
        </div>
        @endif


    </div>
    @endif
</div>