@props(['transaction'])
<div class="mt-4 mb-2 tfss darkandgray" align="left">{{ $transaction->date->format('M d, Y') }}</div>
<a wire:navigate href="{{ route('account.transaction', $transaction->hash) }}" class="darkandwhite tuh m-0 p-0">
    <div class="col-12 mt-1 px-0 mb-1 mx-0 pt-2" align="center">
        <div class="row m-0 p-0">
            <div class="col-2 ms-0 ps-0" align="left">
                <div class="agrcol agrof-3 tfs">
                    <button class="tk border bgdarkandgray p-0" align="center" type="button" style="width: 40px; height: 40px; border-radius: 50%;">
                        <i
                        @class([
                            'bi darkandwhite fs-5',
                            'bi-arrow-down' => $transaction->type == 'receive',
                            'bi-arrow-up' => $transaction->type == 'send',
                            'bi-arrow-left-right' => $transaction->type == 'swap',
                        ])
                        ></i>
                    </button>
                </div>
            </div>
            <div class="col-6 ps-0 pe-0" align="left">
                <span class="fss fw-bold">{{ ucfirst($transaction->type) }}</span><br>
                
                @include('partials.transaction.card-details', ['type' => $transaction->type])
            </div>
            <div class="col-4 p-0 m-0 tfs" align="right">
                <div 
                    @class([
                        'tj-success2' => $transaction->isCredit(),
                        'text-danger' => $transaction->isDebit(),
                    ])>
                    {{ $transaction->full_amount }}<br>{{ $transaction->coin->symbol }}
                </div>
            </div>
        </div>
    </div>
</a>