@props([
    'id', 
    'title',
    'titleIcon' => '',
    'footer' => '', 
    'size' => '',
])
<div class="modal fade" id="{{ $id }}" tabindex="-1" {{ $attributes }} wire:ignore.self>
    <div class="modal-dialog modal-dialog-centered modal-{{ $size }}">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="{{ $id }}Label">
                    @if($titleIcon)
                    <i class="bi bi-{{ $titleIcon }}"></i> 
                    @endif
                    {!! $title !!}
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" @close-modal.window="$el.click()"></button>
            </div>
            <div class="modal-body">
                {{ $slot }}
            </div>
            <div class="modal-footer">
                {{ $footer }}
            </div>
        </div>
    </div>
</div>