@props([
    'coin', 
    'user' => auth_user(),
    'target' => '',
])

    <div {{ $attributes->merge(['class' => 'py-0 border-bottomi']) }}>
        <div class="row mx-0 px-0 position-relative" result1="{{ $coin->name }}" result2="{{ $coin->symbol }}">
            <div class="col-2 mx-0 px-0  position-relative" align="left">
                <x-widgets.coin-image :$coin />
            </div>

            <div class="col-6 mx-0 px-0" align="left">
                <font class="fs-5">{{ $coin->symbol }}</font>
                @if($coin->has_sibling)
                <font class="bgdarkandgray tfss p-1 mx-2 rounded">{{ $coin->network->name }}</font>
                @endif
                <div class="spinner-border text-warning spinner-border-sm" role="status" wire:loading wire:target="{{ $target }}"></div>
                <br>
                <font class="tfss text-muted">{{ $coin->details->total_price }}</font> &nbsp;
                <font @class([
                    'tfss',
                    'text-danger' => $coin->details->change_pct_24h <= 0,
                    'text-success' => $coin->details->change_pct_24h > 0,
                ])>{{ number_format($coin->details->change_pct_24h, 2) }}%</font>
            </div>

            <div class="col-4 mx-0 px-0" align="right">
                <x-widgets.balance>
                    {{ $coin->user_balance->value }}<br>
                </x-widgets.balance>

                <font class="tfss text-muted">
                    <x-widgets.balance>
                        {{ $coin->user->fiat_balance }}<br>
                    </x-widgets.balance>
                </font>
            </div>
            <div class="border-sbottom w-100 pb-3 mb-3"></div>
        </div>
    </div>