@props(['coin'])
<div class="row mx-0 px-0 position-relative" result1="{{ $coin->name }}" result2="{{ $coin->symbol }}">
    <div class="col-2 mx-0 px-0  position-relative" align="left">
        <x-widgets.coin-image :$coin />
    </div>

    <div class="col-6 mx-0 px-0" align="left">
        <font class="fs-5">{{ $coin->full_name }}</font>
        @if($coin->has_sibling)
        <font class="bgdarkandgray tfss p-1 mx-2 rounded">{{ $coin->network->name }}</font>
        @endif
        <br>
        <font class="tfss text-muted">{{ $coin->short_address }}</font>
    </div>
    <div class="col-4 mx-0 px-0" align="right">
        <button class="btn bgdarkandgray border py-1 px-2">
            <x-widgets.copy class="fs-6" :text="$coin->wallet_address" />
        </button>
    </div>
    <div class="border-sbottom w-100 pb-3 mb-3"></div>
</div>