@props(['title', 'bitcoin' => $bitcoin])
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ setting('site_name') }} : {{ $title }}</title>
    <meta name="description"
        content="Easily buy,sell and receive Coins in minutes. Zero fees on recurring purchases. Invest in Cryptocurrency with confidence with world-class security.">
    <meta property="og:image" content="{{ setting('site_favicon') }}">
    <meta property="og:title" content="{{ setting('site_name') }} : {{ $title }}">
    <meta property="og:description"
        content="Easily buy,sell and receive Coins in minutes. Zero fees on recurring purchases. Invest in Cryptocurrency with confidence with world-class security.">
    <meta property="og:type" content="website">
    <meta property="og:URLL" content="/">
    <meta property="og:site_name" content="{{ setting('site_name') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ setting('site_favicon') }}">
    <link rel="icon" type="image/png" href="{{ setting('site_favicon') }}">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="preload" as="style" href="/css/public-5ade5633bffe8ca291607d4203621e99.css?vsn=d">
    <link rel="stylesheet" href="/css/public-5ade5633bffe8ca291607d4203621e99.css?v=2">
    <link href="/css/modal.css?" rel="stylesheet">
    <link rel="stylesheet" href="/css/i.css">
    <link rel="stylesheet" href="/css/translate.css">
    <script src="/js/java.js"></script>
    @livewireStyles
</head>
<style>
    .tjmodal-inner {
        background: #000;
        color: #fff;
        hyphens: none;
    }

    .tjmodal-buttons {
        display: none;
    }

    @media (max-width: 768px) {
        .mt80 {
            margin-top: 70px !important;
        }
    }

    .hlogoin {
        font-size: 30px;
        font-weight: bold;
        display: inline-block;
        position: relative;
        top: 8px;
        /*color:#c5a063;*/
        font-family: fantasy;
    }
</style>
<body id="app">
    @include('partials.pages.nav')

    <main role="main">
        <article
            class="flex flex-col self-center w-full md:max-w-screen-md lg:max-w-screen-lg xl:max-w-screen-xl overflow-hidden  pb-48 mt-18 md:mt-22">
            {{ $slot }}
        </article>
    </main>



    @include('partials.pages.footer')
    <script src="/js/front.js"></script>
    <script src="/js/index.js"></script>
    <script type="text/javascript" src="https://translate.google.cn/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <x-widgets.alert />
    @livewireScripts
    <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '80a73190602c984c9984864774a980ab41618d55';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
</body>

</html>