@props([
    'title',
    'subtitle' => '',
    'left' => '',
    'right' => '',
])

<x-layouts.account :$title>
    <div class="px-2 w-100" {{ $attributes }}>
        <div class="row justify-content-center p-3 mt-0 mb-2 mx-0 bg-traparent " align="center">
            <div class="col-2 px-0" align="left" style="z-index: 1;">
                @if($left)
                {{ $left }}
                @else
                <a onclick="back()">
                    <i class="bi bi-arrow-left text-light" style="font-size:24px;"></i>
                </a>
                @endif
            </div>

            <div class="col-8 pt-2" align="center" style="z-index: 1;">
                <h5>{{ $title }}</h5>
            </div>

            <div class="col-2 px-0" align="right" style="z-index: 1;">
                {{ $right }}
            </div> 

            @if($subtitle)
            <div class="darkandgray tfs mt-2 text-center">{{ $subtitle }}</div>
            @endif
        </div>

        <div class="row p-0 pt-0 mt-0 mb-2 mx-0 bg-traparent">
            <div class="col-12 mt-1 px-3">
                {{ $slot }}
            </div>
        </div>
    </div>
</x-layouts.account>