@props([
    'name',
    'prepend' => '',
    'icon' => '',
])
<div class="input-group input-group-lg border rounded {{ $attributes->get('parent-class') }}">
    @if($prepend)
        {{ $prepend }}
    @else
        @if($icon)
            <span class="input-group-text border-0">
                <i class="bi bi-{{ $icon }} text-muted"></i>
            </span>
        @endif
    @endif
    
    <input {{ $attributes->merge(['class' => 'shadow-none form-control border-0 '.($errors->has($name) ? 'is-invalid': '')]) }} name="{{ $name }}"  
        wire:model="{{ $name }}" 
        {{ $attributes }}>
    {{ $slot }}
</div>

@error($name)
<div class="fw-bolder badge bg-danger">
    {{ $message }}
</div>
@enderror