<div x-data="send_coin(@js($coin->details->price))">
    <div class="tfs p-1 mb-5 alert alert-secondary border-0" align="center">
        Sending via -
        <font class="darkandyellow">
            {{ setting('site_name') }} PayID
        </font>
    </div>

    <form class="mt-4" wire:submit.prevent="validateDetails">
        <div class="pb-2">{{ setting('site_name') }} PayID</div>

        <x-form.input name="form.receiver" placeholder="Receiver's {{ setting('site_name') }} PayID" autocomplete="off">
            <span class="input-group-text border-0 darkandyellow" role="button" @click="paste">
                Paste
            </span>
            <span class="input-group-text border-0 qrscan" role="button" @click="scan">
                <i class="bi bi-qr-code-scan"></i>
            </span>
        </x-form.input>



        <div class="mt-1 px-0">
            <div class="pb-2 pt-3">Amount</div>
            <x-form.input name="form.amount" maxlength="7" placeholder="{{ $coin->symbol }} Amount" autocomplete="off"
                @keyup="getFiat">
                <span class="input-group-text border-0">{{ $coin->symbol }}</span>
                <span class="input-group-text border-0 darkandyellow" role="button"
                    @click="max(@js($coin->user_balance->value))"> Max </span>
            </x-form.input>
        </div>
        <div class="row mt-1 justify-content-start">
            <x-widgets.amount-percentages :$coin />
        </div>


        <div class="mt-1 px-0 pt-3">
            <div class="darkandgray tfss float-start">&#8776; &dollar;
                <font x-text="fiat_amount">0.00</font>
            </div>
            <div class="tfss float-end">Available: {{ $coin->user_balance->value }} {{ $coin->symbol }}</div>
        </div>

        <x-form.submit class="btn btn-warning text-center w-100 mt-5 btn-lg" type="submit" target="validateDetails"
            text="Next" />
    </form>
    <br />
    @include('partials.account.send-bottom-sheet')
</div>