<x-layouts.account-inner title="Receive {{ $coin->full_name }}">
    <div class="row p-0 pt-0 mt-0 mb-2 mx-0 bg-traparent" x-data="receive">
        <div class="col-12 mt-1 px-3">
            <div class="alert alert-warning tfss">
                <i class="bi bi-exclamation-circle-fill"></i> &nbsp;Only send {{ $coin->full_name }} assets to this address.
                Other assets will be lost forever.
            </div>
            <div>
                <div class="row mx-0 px-0 position-relative justify-content-center">
                    <div class="col-2 mx-0 px-0  position-relative" align="right">
                        <img src="{{ $coin->details->full_image }}" width="25px" height="auto"
                            style="background:white; border-radius:50%;" class="aimg"> &nbsp;

                            @if($coin->has_sibling)
                            <img src="{{ $coin->network_coin->details->full_image }}" class="position-absolute border border-light"
                            style="width:12.5px; height:auto; background:white; border-radius:50%; top: 18px; right: 5px;">
                            @endif
                    </div>

                    <div class="col-6 mx-0 px-0" align="left">
                        <font class="fs-5">{{ $coin->symbol }}</font>
                        @if($coin->has_sibling)
                        <font class="bgdarkandgray tfss p-1 mx-2 rounded">{{ $coin->network_coin->name }}</font> 
                        @endif
                        <span class="badge bgdarkandgray darkandgray tfs ms-2 p-2 mt-2">{{ $user->pay_id }}</span><br>
                        <font class="tfss text-muted">{{ $coin->full_name }}</font>
                    </div>
                    
                    <div class="col-4 mx-0 px-0" align="right">
                        <x-widgets.balance>
                            {{ $coin->user_balance->value }} {{ $coin->symbol }}
                        </x-widgets.balance>

                        <x-widgets.balance>
                            <small style="font-size: 10x" class="m-0 p-0">
                                <i>{{ $coin->user->fiat_balance }}</i>
                            </small>
                        </x-widgets.balance>
                    </div>
                    <div class="border-sbottom w-100 pb-3 mb-3"></div>

                </div>
            </div>
            <center>
                <div class="d-inline-block p-3 my-4 shadow-sm bg-white rounded position-relative">
                    <img src="{{ $coin->details->full_image }}" class="position-absolute bg-white rounded p-1"
                        style="width:60px; height:60px; left:0; right:0; margin:0 auto; top:29%;">
                        <div x-qr="{
                            text: @js($coin->wallet_address),
                            width: 190,
                            height: 190,
                        }"></div>
                    <div class="tfss wbrk text-dark mt-3"
                        style="line-height: 17px; width:190px;-webkit-hyphens:manual; -moz-hyphens:manual;hyphens:manual;">
                        {{ $coin->wallet_address }}</div>
                </div>
            </center>
            <div class="row m-0 p-0 justify-content-center">
                <div class="col-12" align="center">

                    <div class="grcol grof-3">
                        <button class="border bgdarkandgray p-0" type="button" align="center" 
                        style="width:55px; height:55px;" 
                        @click="copy(@js(($coin->wallet_address)))">
                            <i class="bi bi-copy fs-2 darkandwhite"></i>
                        </button>
                        <br>
                        Copy
                    </div>

                    <div class="grcol grof-3">
                        <a class="noload"
                            href="https://wa.me/?text={{ $coin->wallet_address }}"
                            target="_blank">
                            <button class="border bgdarkandgray p-0" type="button" align="center" style="width:55px; height:55px;">
                                <i class="bi bi-whatsapp fs-2 darkandwhite"></i>
                            </button>
                        </a>
                        <br>
                        Share
                    </div>

                </div>
            </div>
        </div>
    </div>

    @include('partials.account.receive-footer')
</x-layouts.account-inner>