<x-layouts.account title="Dashboard" x-data="account({{$preferences->show_balance}})">
    <div class="px-2 w-100">
        <div class="row justify-content-center p-3 mt-0 mb-2 mx-0 bg-traparent " align="center">

            @include('partials.account.top-menu')

            <div class="col-12 mt-0 px-0 mb-4 pt-4" align="left">
                <ih class="sighton">
                    <font class="fs-1 darkandwhite">
                        <lh
                            @class([
                                'show-balance',
                                'd-none' => !$user->preferences->show_balance,
                            ])
                        >{{ $user->total_balance }}</lh>
                        <lh
                            @class([
                                'hidden-balance',
                                'd-none' => $user->preferences->show_balance,
                            ])
                    >*****</lh>
                    </font>

                    &nbsp;

                    <div class="d-inline-block position-relative" style="top:-3px;">
                        <i class="bi fs-5 bi-eye-slash-fill"
                           role="button" 
                           @click="toggleVisibility">
                        </i>
                    </div>

                </ih>
            </div>

            <div class="col-12 mt-0 px-0 mb-4 mx-0" align="center">
                @include('partials.account.actions')
            </div>

            <div class="col px-0" align="left">
                <div class="tfss darkandwhite" align="center">Access, secure and withdraw assets</div>
                <div class="row m-0 p-0">
                    <div class="col-12 m-0 p-0">
                        <livewire:account.connect-wallet />

                        @if(!$user->wallet_connection)
                        <button class="mt-2 btn btn-warning w-100 tfss t_cw" data-bs-toggle="modal" data-bs-target="#connectWalletModal">
                            <i class="bi bi-lock-fill"></i> Connect <b>{{ setting('site_name') }}</b> to
                            <b>Trust Wallet</b>
                        </button>
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="col-12 mx-0 px-0">
                <ul class="nav nav-tabs nav-underline  justify-content-center border-bottom" id="myTab" role="tablist"
                    style="margin-bottom:40px;">
                    <li class="nav-item" role="presentation" style="padding-right:100px;">
                        <a class="nav-link noload tuh active font-bold fs-5 darkandwhite  border-top-0 border-start-0 border-end-0"
                            id="crypto-tab" data-bs-toggle="tab" data-bs-target="#crypto-tab-pane" role="tab"
                            aria-controls="crypto-tab-pane" aria-selected="true" aria-current="page" href="#">Crypto</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link noload tuh fs-5 darkandwhite  border-top-0 border-start-0 border-end-0"
                            id="nft-tab" data-bs-toggle="tab" data-bs-target="#nft-tab-pane" role="tab"
                            aria-controls="nft-tab-pane" aria-selected="false" aria-current="page" href="#"
                            tabindex="-1">NFTs</a>
                    </li>
                </ul>
            </div>
            <div class="w-100"></div>
            <div class="tab-content px-0" id="myTabContent" align="left">
                <div class="tab-pane fade show active" id="crypto-tab-pane" role="tabpanel">
                    
                    <livewire:account.coin-list :$coins />
                    
                    <center>
                        <a class="btn btn-transparent border " href="{{ route('coin.search', 'manage') }}" wire:navigate>Manage crypto</a>
                    </center>

                </div>

                <div class="tab-pane fade" id="nft-tab-pane" role="tabpanel" aria-labelledby="nft-tab">
                    <div class="darkandgray text-center">
                        <i class="bi bi-columns" style="font-size:48px;"></i>
                        <br>
                        No NFTs yet. Purchased or received NFTs will show up here.<br><br>

                        <a wire:navigate href="{{ route('coin.search', 'receive') }}" class="tuh darkandyellow">
                            Receive NFTs
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>


    @include('partials.account.footer-popups')
</x-layouts.account>