<x-layouts.account title="{{ $title }}">
    <div class="px-2 w-100">
        <div class="row justify-content-center p-3 mt-0 mb-2 mx-0 bg-traparent " align="center">
            <div class="col-2 px-0" align="left" style="z-index: 1;">
                <a onclick="back();" class="darkandgray">
                    <i class="bi bi-arrow-left" style="font-size:24px;"></i>
                </a>
            </div>

            <div class="col-8 pt-2" align="center" style="z-index: 1;">
                <h4>{{ $title }}</h4>
            </div>

            <div class="col-2 px-0" align="right" style="z-index: 1;">
                @if($action !== 'manage')
                    <a wire:navigate href="{{ route('coin.search', 'manage') }}" class="darkandgray">
                        <i class="bi bi-plus-lg" style="font-size:23px;"></i>
                    </a>
                @endif
            </div>

            <x-widgets.search>

                @foreach ($coins as $coin)
                    @switch($action)
                        @case('search')
                            <a href="{{ $route($coin) }}" class="tuh noload darkandwhite">
                                <x-widgets.coin-card :$coin />
                            </a>
                            @break

                        @case('address')
                            <x-widgets.address-card :$coin />
                            @break   

                        @case('manage')
                            <livewire:account.manage-coin :$coin />
                            @break
                            
                        @case('receive')
                            <a wire:navigate href="{{ route('coin.receive', $coin->uuid) }}" class="tuh noload darkandwhite">
                                <x-widgets.coin-card :$coin />
                            </a>
                        @break
                        
                        @default
                            <x-widgets.coin-card :$coin />
                    @endswitch
                @endforeach
                
            </x-widgets.search>

        </div>
    </div>
</x-layouts.account>