document.addEventListener('alpine:init', () => {
    Alpine.data('alert', () => ({
        show: false,
        alert: '',
        close: false,

        closeAlert() {
            if (this.show) {
                this.show = false;
                this.$refs.alert.classList.add('tjmodal-out')
                setTimeout(() => {
                    this.$refs.alert.classList.remove('tjmodal-out')
                    this.$refs.alert.style.zIndex = '0'
                    this.$refs.alert.style.position = 'absolute'
                    this.$refs.alert.style.left = '-9999999px'
                }, 400);
            }
        },

        showAlert($event) {
            this.$refs.alert.style.zIndex = '11000'
            this.$refs.alert.style.position = ''
            this.$refs.alert.style.left = ''
            setTimeout(() => {
                this.show = true;
                this.alert = $event.detail[0];
            }, 10);
            if ($event.detail[0].type != 'info') {
                setTimeout(() => {
                    this.closeAlert()
                }, 2000);
            }
        }
    }))

    Alpine.data('verify_form', () => ({
        code: '',
        updateCode() {
            this.code = ''
            let codeInputs = document.querySelectorAll('.code');
            codeInputs.forEach(({ value }) => {
                this.code += value
            });
            this.$wire.code = this.code
        },

        startCountdown() {
            if (this.$wire.delay) {
                const countdownInterval = setInterval(() => {
                    if (this.$wire.delay <= 0) {
                        clearInterval(countdownInterval);
                        this.$wire.setDelay(null)
                        return
                    }
                    this.$wire.delay -= 1;
                    this.$wire.setDelay(this.$wire.delay)
                }, 1000);
            }
        }
    }))

    Alpine.data('verify_secret_phrase', () => ({
        phrase: '',
        reshuffled_phrase: [],
        verifying: false,
        active_word: 1,
        verified_words: '',
        verified: false,

        init() {
            this.phrase = this.$wire.secret_phrase
        },

        shuffle(array) {
            const newArray = array.slice()
            for (let i = newArray.length - 1; i > 0; i--) {
                const j = Math.floor(Math.random() * (i + 1));
                [newArray[i], newArray[j]] = [newArray[j], newArray[i]]
            }
            return newArray;
        },

        ordinal(num) {
            const ordinals = [
                "zeroth", "first", "second", "third", "fourth", "fifth", "sixth", "seventh",
                "eighth", "ninth", "tenth"
            ];

            return ordinals[num] || num + "th"
        },

        removeItem(array, value) {
            return array.filter(item => item !== value);
        },

        start() {
            this.verifying = true
            this.reshuffled_phrase = this.active_word === 1 ? this.shuffle(this.phrase): this.reshuffled_phrase

        },

        replace(str, charToRemove = ',') {
            while (str.endsWith(charToRemove)) {
                str = str.slice(0, -1);
            }
            return str;
        },

        verify(word) {

            let active_word = this.active_word - 1
            if (this.phrase[active_word] == word) {
                this.verified_words += `${this.phrase[active_word]},`

                this.reshuffled_phrase = this.removeItem(this.reshuffled_phrase, word)
                this.active_word += 1
                if (!this.reshuffled_phrase.length) {
                    this.verified = true;
                }
            } else {
                this.$dispatch('alert', [{
                    type: 'notice',
                    text: `<span class="text-warning fw-bold">${word}</span> is not the ${this.ordinal(this.active_word)} word.`,
                }])
            }
        }
    }))

    Alpine.data('pin', (action) => ({
        pin: '',
        wrong: false,

        init() {
            const pinButtons = document.querySelectorAll('.pin-number')
            pinButtons.forEach(button => {
                button.addEventListener('click', ({ target }) => {
                    if (this.pin.length < 4) {
                        this.pin += target.innerHTML
                    }
                    if (this.pin.length >= 4) {
                        this.wrong = false
                        this.$wire.pin = this.pin
                        this.$wire[action]()
                    }
                })
            })
        },

        backspace() {
            if (this.pin.length) {
                this.wrong = false
                this.pin = this.pin.substring(0, this.pin.length - 1)
            }
        },

        wrong_pin() {
            this.pin = ''
            this.wrong = true

            setTimeout(() => {
                document.querySelector('#fields').classList.remove('animate__shakeX')
            }, 100);
        }
    }))

    
})