<?php

namespace Database\Seeders;

use App\Models\Plan;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PlanSeeder extends Seeder {
    /**
     * Run the database seeds.
     */
    public function run(): void {
        $plans = [
            [
                'coin_id' => '2',
                'minimum_investment' => 100,
                'maximum_investment' => 0,
                'increment' => 0.7,
                'increment_interval' => 'weekly',
                'duration' => '10 Days',
            ],
            [
                'coin_id' => '3',
                'minimum_investment' => 100,
                'maximum_investment' => 0,
                'increment' => 0.7,
                'increment_interval' => 'weekly',
                'duration' => '10 Days',
            ],
            [
                'coin_id' => '6',
                'minimum_investment' => 100,
                'maximum_investment' => 0,
                'increment' => 0.7,
                'increment_interval' => 'weekly',
                'duration' => '10 Days',
            ],
        ];

        foreach ($plans as $plan) {
            Plan::create($plan);
        }
    }
}
