<?php

namespace Database\Seeders;

use App\Models\Coin;
use App\Models\Network;
use App\Models\Setting;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder {

    public function run(): void {
        $settings = [
            [
                'key' => 'site_name',
                'value' => 'TrustJex',
            ],
            [
                'key' => 'site_email',
                'value' => 'enquiries@trustjex.com',
            ],
            [
                'key' => 'site_logo',
                'value' => '/logo/ibwhite.png',
            ],
            [
                'key' => 'site_favicon',
                'value' => '/logo/favicon.png',
            ],
            [
                'key' => 'site_url',
                'value' => 'https://www.trustjex.com'
            ],
            [
                'key' => 'otp_expiration',
                'value' => 60,
            ],
            [
                'key' => 'currency',
                'value' => '$',
            ],
            [
                'key' => 'currency_full',
                'value' => 'USD',
            ],
            [
                'key' => 'cryptocompare_api_key',
                'value' => 'e56f08e6824fb6366a129bfbc908d8db9c091e8a41846b16303afa42ea98b435',
            ]
        ];

        foreach ($settings as $setting) {
            Setting::create($setting);
        }

        $coins = [
            [
                'network_id' => '1',
                'name' => 'Bitcoin',
                'wallet_address' => '1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa',
                'symbol' => 'BTC',
                'uuid' => Str::uuid(),
            ],
            [
                'network_id' => '3',
                'name' => 'USDT',
                'wallet_address' => 'T9yD14Nj9j7xAB4dbGeiX9h8unkKHxuWwb',
                'symbol' => 'USDT',
                'uuid' => Str::uuid(),
            ],
            [
                'network_id' => '2',
                'name' => 'USDT',
                'wallet_address' => '0xdAC17F958D2ee523a2206206994597C13D831ec7',
                'symbol' => 'USDT',
                'uuid' => Str::uuid(),
            ],
            [
                'network_id' => '2',
                'name' => 'Ethereum',
                'wallet_address' => '0x742d35Cc6634C0532925a3b844Bc454e4438f44e',
                'symbol' => 'ETH',
                'uuid' => Str::uuid(),
            ],
            [
                'network_id' => '3',
                'name' => 'Tron',
                'wallet_address' => 'T9yD14Nj9j7xAB4dbGeiX9h8unkKHxuWwb',
                'symbol' => 'TRX',
                'uuid' => Str::uuid(),
            ],
            [
                'network_id' => '5',
                'name' => 'USDT',
                'wallet_address' => 'bnb1tqq9llyr3dyjd559dha6z5r5etk3qfwk07m098',
                'symbol' => 'USDT',
                'uuid' => Str::uuid(),
            ],
            [
                'network_id' => '4',
                'name' => 'Bitcoin Cash',
                'wallet_address' => 'qz8af8txmcr93sufzf7nf22wzr8c27zgf6y3zqsz7m',
                'symbol' => 'BCH',
                'uuid' => Str::uuid(),
            ],

            [
                'network_id' => '6',
                'name' => 'Litecoin',
                'wallet_address' => 'LZP7c4uAgSUdxo6SCZhvEjUe1yJd3P3EUX',
                'symbol' => 'LTC',
                'uuid' => Str::uuid(),
            ],
            [
                'network_id' => '7',
                'name' => 'Stellar',
                'wallet_address' => 'GAEDRMQY5T5ONL47AUB6XW32Y4GF4FZN7CRUPRBRP24UBVO5Z5S3O4GP',
                'symbol' => 'XLM',
                'uuid' => Str::uuid(),
            ],

            [
                'network_id' => '8',
                'name' => 'Dash',
                'wallet_address' => 'XxMF6s4M4k5xxs3kk7tWvb7KdtKN57KRYs',
                'symbol' => 'DASH',
                'uuid' => Str::uuid(),
            ],

            [
                'network_id' => '9',
                'name' => 'Dogecoin',
                'wallet_address' => 'D8B6vnxdxLNZ1wE46sYTSa3kmG7f5Kcxqh',
                'symbol' => 'DOGE',
                'uuid' => Str::uuid(),
            ],

            [
                'network_id' => '10',
                'name' => 'Solana',
                'wallet_address' => '5Kn7c5ZkkrHS1yz7R72gZPjggg1shxUuaPU6VtTLZ5L',
                'symbol' => 'SOL',
                'uuid' => Str::uuid(),
            ],
            [
                'network_id' => '5',
                'name' => 'BNB',
                'wallet_address' => 'bnb1tqq9llyr3dyjd559dha6z5r5etk3qfwk07m098',
                'symbol' => 'BNB',
                'uuid' => Str::uuid(),
            ],
        ];

        $networks = [
            [
                'name' => 'Bitcoin',
                'symbol' => 'BTC'
            ],
            [
                'name' => 'ERC20',
                'symbol' => 'ETH'
            ],
            [
                'name' => 'TRC20',
                'symbol' => 'TRX'
            ],
            [
                'name' => 'Bitcoin Cash',
                'symbol' => 'BCH'
            ],
            [
                'name' => 'BNB',
                'symbol' => 'BNB'
            ],
            [
                'name' => 'Litecoin',
                'symbol' => 'LTC'
            ],
            [
                'name' => 'Stellar',
                'symbol' => 'XLM'
            ],
            [
                'name' => 'Dash',
                'symbol' => 'DASH'
            ],
            [
                'name' => 'Dogecoin',
                'symbol' => 'DOGE'
            ],
            [
                'name' => 'Solana',
                'symbol' => 'SOL'
            ]
        ];

        foreach($networks as $network) {
            Network::create($network);
        }

        foreach($coins as $coin) {
            Coin::create($coin);
        }
    }
}
