<?php

use App\Models\Coin;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Coin::class)->constrained()->cascadeOnDelete();
            $table->string('minimum_investment')->default(500);
            $table->string('maximum_investment')->default(0);
            $table->boolean('is_active')->default(true);
            $table->string('increment');
            $table->string('increment_interval');
            $table->string('duration');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('plans');
    }
};
