<?php

use App\Models\Coin;
use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {    
            $table->id();
            $table->foreignIdFor(User::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(Coin::class)->constrained()->cascadeOnDelete();
            $table->string('amount');
            $table->string('network_fee');
            $table->dateTime('date');
            $table->string('status');
            $table->json('details');
            $table->string('type');
            $table->enum('direction', ['credit', 'debit']);
            $table->string('hash');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
