<?php

use App\Models\Coin;
use App\Models\User;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(User::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(Coin::class)->constrained()->cascadeOnDelete();
            $table->boolean('is_active')->default(true);
            $table->decimal('network_fee', 5, 2)->default(0.1);
            $table->decimal('swap_fee', 5, 2)->default(0.1);
            $table->decimal('irs_fee', 5, 2)->default(0.1);
            $table->string('minimum_withdrawal')->default(0);
            $table->string('minimum_swap')->default(0);
            $table->string('minimum_buy')->default(500);
            $table->boolean('allow_payid_send')->default(false);
            $table->boolean('allow_send')->default(true);
            $table->boolean('allow_swap')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_settings');
    }
};
