<?php

use App\Models\Coin;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coin_details', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Coin::class)->constrained()->cascadeOnDelete();
            $table->decimal('price', 20, 8)->nullable();
            $table->string('image')->nullable();
            $table->string('change_24h')->nullable();
            $table->string('change_pct_24h')->nullable();
            $table->string('high_24h')->nullable();
            $table->string('low_24h')->nullable();
            $table->json('others')->nullable();
            $table->timestamp('last_updated')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coin_details');
    }
};
