<?php

use App\Http\Middleware\EnsurePinIsEntered;
use App\Http\Middleware\EnsurePinIsSet;
use App\Http\Middleware\EnsureSecretPhraseIsBackedUp;
use App\Http\Middleware\RedirectIfSecretPhaseHasBeenBackedUp;
use Illuminate\Auth\Middleware\Authenticate;
use Illuminate\Auth\Middleware\EnsureEmailIsVerified;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->appendToGroup('account', [
            EnsurePinIsSet::class,
            Authenticate::class,
            EnsureEmailIsVerified::class,
            EnsureSecretPhraseIsBackedUp::class,
            EnsurePinIsEntered::class,
        ]);

        $middleware->appendToGroup('backed-up', [
            RedirectIfSecretPhaseHasBeenBackedUp::class,
            Authenticate::class,
            EnsureEmailIsVerified::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
