<?php

use App\Models\Coin;
use App\Models\User;
use App\Models\Setting;

if (!function_exists('setting')) {
    function setting($key) {
        $setting = Setting::firstWhere('key', $key);
        return $setting?->value;
    }
}
if (!function_exists('count_digits')) {
    function count_digits($str) {
        preg_match_all('/\d/', $str, $matches);

        return count($matches[0]);
    }
}

if (!function_exists('convert_text')) {
    function convert_text($input) {
        $words = explode('_', $input);
        $words = array_map('ucfirst', $words);
        return implode(' ', $words);
    }
}

if (!function_exists('generate_otp')) {
    function generate_otp() {
        $firstDigit = random_int(1, 9);
        $secondDigit = random_int(1, 9);
        $thirdDigit = random_int(1, 9);
        $fourthDigit = random_int(1, 9);
        $otp = $firstDigit . $secondDigit . $thirdDigit . $fourthDigit;

        return (int) $otp;
    }
}


if (!function_exists('symbols')) {
    function symbols() {
        $coins = Coin::all();
        $symbols = '';

        foreach ($coins as $coin) {
            $symbols = $symbols . $coin->symbol . ',';
        }

        return trim($symbols, ',');
    }
}

function auth_user() {
    return User::find(auth()->id());
}

if (!function_exists('network_fee_text')) {
    function network_fee_text($network_fee, Coin $coin) {
        $siteCurrency = setting('currency');
        $networkFeeFiat = number_format($network_fee->fiat, 2);
        $networkFeeCoin = number_format($network_fee->coin, 2);
        return "{$networkFeeCoin} {$coin->symbol} (≈ {$siteCurrency}{$networkFeeFiat})";
    }
}


if (!function_exists('shorten_id')) {
    function shorten_id(string $id): string {
        return substr($id, 0, 7) . '...' . substr($id, -7);
    }
}

if (!function_exists('shorten_address')) {
    function shorten_address(string $wallet_address): string {
        if (strlen($wallet_address) <= 12) {
            return $wallet_address;
        }

        return substr($wallet_address, 0, 7) . '...' . substr($wallet_address, -7);
    }
}

if (!function_exists('convert_singular')) {
    function convert_singular(string $frequency) {
        $mappings = [
            'daily' => 'Day',
        ];

        return $mappings[$frequency] ?? ucfirst(str_replace('ly', '', $frequency));
    }
}

if (!function_exists('is_image_link')) {
    function is_image_link($string) {
        return preg_match('/\.(jpg|jpeg|png|gif|bmp|svg)$/i', $string);
    }
}
