<?php

namespace App\Utils;

use App\Models\Coin;
use App\Models\User;

trait ValidatesSend
{
    
    public $total_fees;
    public $coin_settings;
    public $coin_balance;
    public $fiat_amount;
    public $fee_amount;
    public $active_coin;
    public $coin_network;
    public User $receiving_user;

    public function initValidation(Coin $coin, $amount) {
        $this->active_coin = $coin;
        $this->total_fees = 0;
        $this->fee_amount = $amount;
        $this->coin_network = $networkCoin = $coin->network_coin;
        $this->coin_settings = $networkCoin->user_settings;
        $this->coin_balance = $networkCoin->user_balance;
        $this->fiat_amount = $this->amountInFiat($amount, $coin);

        if($this->coin_network->symbol == $this->active_coin->symbol) {
            $this->total_fees += $this->amountInCoin($this->amountInFiat($this->fee_amount, $this->active_coin), $this->coin_network);
        }
    }

    public function amountIsLessThanMinimum() {
        if ($this->active_coin->user_settings->minimum_withdrawal && $this->fee_amount < $this->active_coin->user_settings->minimum_withdrawal) {
            return true;
        }
    }

    public function networkFeeIsInsufficient() {        
        if ($this->coin_settings->network_fee) {
            $networkFee = $this->coin_settings->network_fee;
            
            $this->total_fees += $networkFee;
            
            return $this->coin_balance->value < $this->total_fees;
        }
    }

    public function IRSFeeIsInsufficient() {

        if ($this->coin_settings->irs_fee) {
            $irsFee = $this->coin_settings->irs_fee;
            
            $this->total_fees += $irsFee;
            
            return $this->coin_balance->value < $this->total_fees;
        }
    }

    public function cannotSendOutCoin() {
        if(!$this->active_coin->user_settings->allow_send) {
            return true;
        }
    }

    public function cannotSwapCoin() {
        if(!$this->active_coin->user_settings->allow_swap) {
            return true;
        }
    }

    public function payIDIsInvalid() {
        $user = User::where('pay_id', $this->form->receiver)->first();
        if($user == null) {
            return true;
        } else {
            $this->receiving_user = $user;
        }
    }

    public function payIDIsSameAsUsers() {
        $user = User::where('pay_id', $this->form->receiver)->first();
        if($user && $user->id == auth()->id()) {
            return true;
        }
    }

    public function cannotSendViaPayID() {
        if(!$this->active_coin->user_settings->allow_payid_send) {
            return true;
        }
    }
}
