<?php

namespace App\Utils;

use App\Models\Coin;

trait ProcessesFees {

    public $no_fee = false;

    public function fee($type = 'network', Coin $coin = null, $amount = null) {
        $activeCoin = $coin ?? $this->coin;
        $activeAmount = $amount ?? $this->form->amount;

        $networkCoin = $activeCoin->network_coin;
        $networkCoinSettings = $networkCoin->user_settings;

        $fee = $type . '_fee';

        $fee = $networkCoinSettings->$fee;
        $feeInFiat = $this->amountInFiat($fee, $networkCoin);

        return (object) [
            'coin' => $this->no_fee ? 0 : $fee,
            'fiat' => $this->no_fee ? 0 : $feeInFiat,
        ];
    }

    public function totalFees(Coin $coin = null, $amount = null) {
        $totalInFiat = $this->fee(
            coin: $coin,
            amount: $amount
        )->fiat + $this->fee(
            coin: $coin,
            amount: $amount,
            type: 'irs'
        )->fiat;
        $totalInCoin = $this->fee(
            coin: $coin,
            amount: $amount
        )->coin + $this->fee(
            coin: $coin,
            amount: $amount,
            type: 'irs'
        )->coin;
        return (object) [
            'fiat' => $totalInFiat,
            'coin' => $totalInCoin,
        ];
    }

    public function fees(Coin $coin = null, $amount = null) {
        $fees = [];
        $total = $this->totalFees($coin, $amount);

        $fees['network'] = $this->fee(
            type: 'network',
            coin: $coin,
            amount: $amount,
        );

        $fees['irs'] = $this->fee(
            type: 'irs',
            coin: $coin,
            amount: $amount,
        );
        $fees['total'] = $total;

        return (object) ($fees);
    }
}
