<?php

namespace App\Utils;

use App\Models\User;

trait ManagesSecretPhrase {
    
    public function generateSecretPhrase($numWords = 12) {
        $wordListFile = public_path('wordlist.txt');
        $wordList = file($wordListFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        shuffle($wordList);

        $secretPhrase = array_slice($wordList, 0, $numWords);

        return implode(' ', $secretPhrase);
    }

    public function secretPhraseList(string $phrase): array {
        return explode(' ', $phrase);
    }

    public function secretPhraseIsIncorrect($phrase, User $user) {
        return $user->secret_phrase !== $phrase;
    }
}
