<?php

namespace App\Utils;

use App\Models\User;

trait HandlesSwap
{
    use ConvertsAmount, DispatchContent, ProcessesFees, ValidatesSend;

    public function updateDetails() {
        $fromAmountInFiat = $this->amountInFiat($this->amount, $this->from_coin);
        $toAmountInCoin = $this->coinAmountInCoin($this->amount, $this->from_coin, $this->to_coin);
        $toAmountInFiat = $this->amountInFiat($toAmountInCoin, $this->to_coin);

        return [
            'from' => [
                'price' => $this->from_coin->details->price,
                'fiat_amount' => number_format($fromAmountInFiat, 2),
            ],
            'to' => [
                'price' => $this->to_coin->details->price,
                'coin_amount' => sprintf('%.4f', $toAmountInCoin),
                'fiat_amount' => number_format($toAmountInFiat, 2),
            ]
        ];
    }

    public function balanceIsInsufficient() {
        return $this->from_coin->user->balance < $this->amount;
    }

    public function amountIsLessMinimumSwap() {
        return $this->from_coin->user_settings->minimum_swap && $this->amount < $this->from_coin->user_settings->minimum_swap;
    }

    public function createTransaction() {
        $user = User::find(auth()->id());
        $data = $this->updateDetails();

        $transaction = $user->transactions()->create([
            'coin_id' => $this->from_coin->id,
            'date' => now(),
            'status' => 'pending',
            'amount' => $this->amount,
            'network_fee' => $this->network_fee->coin,
            'hash' => bin2hex(random_bytes(32)),
            'direction' => 'debit',
            'type' => 'swap',
            'details' => [
                'fiat_amount' => $data['from']['fiat_amount'],
                'network_fee' => network_fee_text($this->network_fee, $this->from_coin),
                'from' => $this->from_coin->full_name,
                'to' => $this->to_coin->full_name,
                'nonce' => 0,
                'from_coin' => $this->from_coin->id,
                'from_coin_amount' => $this->amount,
                'from_fiat_amount' => $data['from']['fiat_amount'],
                'slippage' => 1,
                
                'to_coin' => $this->to_coin->id,
                'to_coin_amount' => $data['to']['coin_amount'],
                'to_fiat_amount' => $data['to']['fiat_amount'],
            ],
        ]);

        return $transaction;
    }
    
}
