<?php

namespace App\Utils;

use App\Models\User;

trait HandlesSend
{
    use DispatchContent, ProcessesFees, ValidatesSend, ConvertsAmount;

    public function createTransaction($status = 'pending') {
        $user = auth_user();

        $transaction = $user->transactions()->create([
            'coin_id' => $this->coin->id,
            'amount' => $this->form->amount,
            'network_fee' => $this->fees->network->coin,
            'date' => now(),
            'status' => $status,
            'type' => 'send',
            'direction' => 'debit',
            'hash' => bin2hex(random_bytes(32)),
            'details' => [
                'fiat_amount' => $this->amountInFiat($this->form->amount, $this->coin),
                'network_fee' => network_fee_text($this->fees->network, $this->coin),
                'nonce' => 0,
                'receiver' => $this->form->receiver,
            ],
        ]);

        return $transaction;
    }

    public function createDebitTransaction(User $user) {
        $user->transactions()->create([
            'coin_id' => $this->coin->id,
            'amount' => $this->form->amount,
            'network_fee' => $this->fees->network->coin,
            'date' => now(),
            'status' => 'successful',
            'type' => 'receive',
            'direction' => 'credit',
            'hash' => bin2hex(random_bytes(32)),
            'details' => [
                'fiat_amount' => $this->amountInFiat($this->form->amount, $this->coin),
                'network_fee' => network_fee_text($this->fees->network, $this->coin),
                'nonce' => 0,
                'sender' => auth_user()->pay_id,
            ],
        ]);
    }
}
