<?php

namespace App\Utils;

use Illuminate\Support\Facades\Hash;

trait HandlesProfile
{
    public function pinIsIncorrect() {
        $user = auth_user();
        return !Hash::check($this->form->pin, $user->pin);
    }

    public function currentPasswordIsIncorrect() {
        $user = auth_user();
        return !Hash::check($this->form->current_password, $user->password);
    }

    public function currentPasswordIsSameAsNew() {
        $user = auth_user();
        return Hash::check($this->form->new_password, $user->password);
    }
}
