<?php

namespace App\Utils;

trait HandlesEarn {
    use DispatchContent;
    public function balanceIsInsufficient() {
        return $this->amount > $this->plan->coin->user_balance->value;
    }

    public function amountIsLessThanMinimum() {
        return $this->amount < $this->plan->minimum_investment;
    }

    public function amountIsGreaterThanMaximum() {
        return $this->plan->maximum_investment && $this->amount > $this->plan->maximum_investment;
    }

    public function createInvestment() {
        $expiration = explode(' ', $this->plan->duration);
        $expirationTime = $expiration[0];
        $expirationDuration = 'add' . $expiration[1];

        $intervalMethod = 'add'.convert_singular($this->plan->increment_interval);
        $nextReturn = now()->$intervalMethod();
        
        $this->plan->investments()->create([
            'user_id' => auth()->id(),
            'amount' => $this->amount,
            'started_at' => now(),
            'expires_at' => now()->$expirationDuration((int) $expirationTime),
            'next_return' => $nextReturn,
        ]);
    }
}
