<?php

namespace App\Utils;

use App\Models\Coin;
use App\Models\Plan;

trait DispatchContent {

    public function insufficientBalance(Coin $coin) {
        $url = route('coin.buy', $coin->uuid);

        return
            <<<HTML
                 Not enough balance.
                <a wire:navigate href="$url" class="tuh darkandyellow">
                    <b>Buy {$coin->symbol}</b>
                </a>
                and try again
            HTML;
    }

    public function lessThanMinimum() {
        $siteName = setting('site_name');
        $minWithdrawal = number_format($this->coin->user_settings->minimum_withdrawal, 2);
        return <<<HTML
                The minimum amount you can send out is 
                <b class="text-warning">{$minWithdrawal}
                    <img src="{$this->coin->details->full_image}" width="20px" height="auto" style="background:white; border-radius:50%;" class="aimg"> &nbsp;{$this->coin->symbol}
                </b>. 
                This amount varies depending on your $siteName crypto balance.
        HTML;
    }

    public function notInvestmentAmount(Plan $plan, $type) {
        $column = $type.'_investment';
        $investmentAmount = number_format($plan->$column, 2);
        return <<<HTML
                The $type amount you can invest for this plan is
                <b class="text-warning">{$investmentAmount}
                    <img src="{$plan->coin->details->full_image}" width="20px" height="auto" style="background:white; border-radius:50%;" class="aimg"> &nbsp;{$plan->coin->symbol}
                </b>.
        HTML;
    }

    public function insufficientFee($type = 'network', $fee = null, Coin $coin = null) {
        $coin = $coin ?? $this->coin;
        $siteName = setting('site_name');
        if($fee == null) {
            $fee = $type == 'network' ? number_format($this->fees->network->coin, 2) : number_format($this->fees->irs->coin, 2);
        }

        return <<<HTML
            <div>
                Insufficient {$coin->network_coin->symbol} to cover $type and gas fee.
                You need to deposit <br><b class="text-warning">$fee
                
                <img src="{$coin->network_coin->details->full_image}" width="20px" height="auto" style="background:white; border-radius:50%;" class="aimg"> {$coin->network_coin->symbol}</b><br> 
                
                into your
                $siteName {$coin->network_coin->symbol} wallet to proceed
                <hr>
                <div class="tfs pb-2">
                    <div class="">
                        <font class="text-muted tfss">
                            These are blockchain transaction fee. 
                            $siteName does not charge any fee. 
                            0% of these fees are paid to $siteName
                        </font>
                    </div>
                    <hr>
                    <font class="text-secondary"> Click to read more:</font>&nbsp; <a
                        href="https://www.google.com/search?q=what is {$coin->network_coin->symbol} $type gas fee" target="_blank"
                        class="noload tuh text-warning">What is {$coin->network_coin->symbol} $type gas fee and why is it needed for this transaction?</a>
                </div>
            </div>
        HTML;
    }

    public function payIDSendNotAllowed() {
        $url = route('coin.send', $this->coin->uuid);
        return <<<HTML
            <div>
                Your account hasn't met the minimum transaction requirement to send via Pay ID. Please complete
                more transactions to become eligible, 
                
                or click
                <a wire:navigate
                    href="$url"
                    class="text-warning fw-bold tuh">
                    here
                </a> 
                to 
                <a wire:navigate href="$url"
                    class="text-warning fw-bold tuh">send coins via cryptocurrency
                </a> 
                to an external wallet.
            </div>
        HTML;
    }

    public function coinSendNotAllowed($for = 'send out') {
        $siteName = setting('site_name');
        $siteEmail = setting('site_email');
        $url = "mailto:$siteEmail";
        return <<<HTML
            <div>
                You cannot complete this transaction.
                Click <a
                    href="$url"
                    class="text-warning fw-bold tuh">
                    here
                </a>to contact $siteName support
            </div>
        HTML;
    }

    public function lessThanMinimumSwap() {
        $minSwap = number_format($this->from_coin->user_settings->minimum_swap, 2);
        $minSwapInFiat = $this->amountInFiat($this->from_coin->user_settings->minimum_swap, $this->from_coin);
        $minSwapInFiat = number_format($minSwapInFiat, 2);
        $currency = setting('currency');

        return
            <<<HTML
            <div>
                The minimum amount you can swap is 
                <b class="darkandyellow">$currency$minSwapInFiat ≈ $minSwap
                    <img src="{$this->from_coin->details->full_image}" 
                        width="20px" height="auto" 
                        style="background:white; border-radius:50%;" 
                        class="fimg">
                    {$this->from_coin->symbol}
                </b> 
            </div>
        HTML;
    }

    public function balanceInsufficient() {
        return <<<HTML
        <div>
            The amount you are trying to swap is greater than your 
            <b class="darkandyellow">
                <img src="{$this->from_coin->details->full_image}" width="20px" height="auto" style="background:white; border-radius:50%;" class="fimg">
                 {$this->from_coin->symbol}
            </b> balance.
        </div>
        HTML;
    }
}
