<?php

namespace App\Utils;

use App\Models\Coin;
use App\Models\User;

class CreatesTransaction
{
    use ConvertsAmount, ProcessesFees;

    public Coin $coin;
    public User $active_user;
    public string $amount;
    public object $fees;
    public $receiver;
    
    public function init(Coin $coin, User $user, $amount): void {
        $this->coin = $coin;
        $this->active_user = $user;
        $this->amount = $amount;
        $this->fees = $this->fees($coin, $amount);
        $this->receiver = shorten_address($coin->wallet_address);
    }

    public function createDebitTransaction($status = 'successful') {

        $transaction = $this->active_user->transactions()->create([
            'coin_id' => $this->coin->id,
            'amount' => $this->amount,
            'network_fee' => $this->fees->network->coin,
            'date' => now(),
            'status' => $status,
            'type' => 'send',
            'direction' => 'debit',
            'hash' => bin2hex(random_bytes(32)),
            'details' => [
                'fiat_amount' => $this->amountInFiat($this->amount, $this->coin),
                'network_fee' => network_fee_text($this->fees->network, $this->coin),
                'nonce' => 0,
                'receiver' => $this->receiver,
            ],
        ]);

        return $transaction;
    }

    public function createCreditTransaction() {
        $this->active_user->transactions()->create([
            'coin_id' => $this->coin->id,
            'amount' => $this->amount,
            'network_fee' => $this->fees->network->coin,
            'date' => now(),
            'status' => 'successful',
            'type' => 'receive',
            'direction' => 'credit',
            'hash' => bin2hex(random_bytes(32)),
            'details' => [
                'fiat_amount' => $this->amountInFiat($this->amount, $this->coin),
                'network_fee' => network_fee_text($this->fees->network, $this->coin),
                'nonce' => 0,
                'sender' => $this->receiver,
            ],
        ]);
    }
}
