<?php

namespace App\Utils;

use App\Models\Coin;

trait ConvertsAmount
{
    public function amountInCoin($amount, Coin $coin) {
        return $amount / $coin->details->price;
    }

    public function amountInFiat($amount, Coin $coin) {
        return $amount * $coin->details->price;
    }

    public function coinAmountInCoin($amount, Coin $coinFrom, Coin $coinTo) {
        $fromAmountInFiat = $this->amountInFiat($amount, $coinFrom);
        $fromAmountInToCoin = $this->amountInCoin($fromAmountInFiat, $coinTo);

        return $fromAmountInToCoin;
    }
}
