<?php

namespace App\Rules;

use App\Models\User;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\Auth;

class ValidOTP implements ValidationRule
{
    public function __construct(public int $digits = 4) {}
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        
        $user = User::find(auth()->id());
        $latestOTP = $user->otps()->latest()->first();

        if(empty($value)) {
            $fail('The :attribute is required.');
        }

        if(count_digits($value) < $this->digits) {
            $fail("The :attribute must be {$this->digits} digits.");
        }

        if(!is_numeric($value)) {
            $fail('The :attribute must be a number.');
        }

        if ($value != $latestOTP->code) {
            $fail('The :attribute is incorrect.');
        }

        if($latestOTP->expires_at->isPast()) {
            $fail('The :attribute has expired.');
        }
    }
}
