<?php

namespace App\Observers;

use App\Models\Coin;
use App\Models\User;

class UserObserver
{
    /**
     * Handle the User "created" event.
     */
    public function created(User $user): void
    {
        $coins = Coin::all();

        foreach($coins as $coin) {
            $user->balances()->create([
                'coin_id' => $coin->id
            ]);
            $user->settings()->create([
                'coin_id' => $coin->id
            ]);
        }
        $user->preferences()->create();
    }

    public function updated(User $user): void{}

    public function deleted(User $user): void{}

    public function restored(User $user): void{}

    public function forceDeleted(User $user): void{}
}
