<?php

namespace App\Observers;

use App\Models\Coin;
use App\Models\User;

class CoinObserver 
{
    /**
     * Handle the Coin "created" event.
     */
    public function created(Coin $coin): void {
        $users = User::all();

        foreach ($users as $user) {
            $user->balances()->create([
                'coin_id' => $coin->id,
            ]);

            $user->settings()->create([
                'coin_id' => $coin->id
            ]);
        }

        $coin->details()->create();
    }

    /**
     * Handle the Coin "updated" event.
     */
    public function updated(Coin $coin): void {
    }

    /**
     * Handle the Coin "deleted" event.
     */
    public function deleted(Coin $coin): void {
    }

    /**
     * Handle the Coin "restored" event.
     */
    public function restored(Coin $coin): void {
    }

    /**
     * Handle the Coin "force deleted" event.
     */
    public function forceDeleted(Coin $coin): void {
    }
}
