<?php

namespace App\Notifications\User;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class Welcome extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(public int $otp){}

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(User $user): MailMessage
    {
        $site_name = setting('site_name');
        $site_email = setting('site_email');
        return (new MailMessage)
                    ->subject('Account Created')
                    ->greeting("Hello {$user->name},")
                    ->line("Welcome to {$site_name}, one of the world's best crypto trading company. Your account was successfully created.")
                    ->line("Your code is {$this->otp}")
                    ->action('Continue Verification', route('email.verify'));
    }

    /**
     * Get the database representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(User $user): array
    {
        $site_name = setting('site_name');
        return [
            'title' => "Welcome to {$site_name}",
            'message' => "You created your account on {$user->created_at}",
        ];
    }
}
