<?php

namespace App\Notifications\User;

use App\Models\OTP as ModelsOTP;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class OTP extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    
    public function __construct(public ModelsOTP $otp) {}

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $purpose = convert_text($this->otp->purpose);
        return (new MailMessage)
                    ->subject("$purpose Code")
                    ->greeting("Hello $notifiable->name,")
                    ->line("Here is the OTP you requested.")
                    ->line($this->otp->code)
                    ->line("This OTP will expire in {$this->otp->expires_at->diffForHumans()}");
    }
}
