<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSetting extends Model
{
    protected $guarded = ['id'];
    
    protected $casts = [
        'irs_fee' => 'float',
        'network_fee' => 'float',
        'allow_send' => 'boolean',
        'allow_swap' => 'boolean',
        'is_active' => 'boolean',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function coin() {
        return $this->belongsTo(Coin::class);
    }
}
