<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;
    
    protected $guarded = ['id'];
    
    protected $casts = [
        'is_active' => 'boolean',
        'started_at' => 'datetime',
        'expires_at' => 'datetime',
    ];

    public static function active() {
        return static::where('is_active', true);
    }

    public function coin() {
        return $this->belongsTo(Coin::class);
    }

    public function investments() {
        return $this->hasMany(Investment::class);
    }

    public function fullMinimum(): Attribute {
        return Attribute::make(get: fn() => $this->minimum_investment. ' '. $this->coin->full_name);
    }

    public function fullMaximum(): Attribute {
        return Attribute::make(get: fn() => $this->maximum_investment  ? $this->maximum_investment. ' '. $this->coin->full_name : 'Unlimited');
    }
}
