<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OTP extends Model {
    use HasFactory;

    protected $guarded = ['id'];

    protected $table = 'otps';

    protected $casts = [
        'expires_at' => 'datetime'
    ];

    public function invalidate() {
        if ($this->expires_at->isFuture()) {
            return $this->update([
                'expires_at' => now()
            ]);
        }
    }

    public function user() {
        return $this->belongsTo(User::class);
    }
}
