<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Network extends Model
{
    use HasFactory;
    
    protected $guarded = ['id'];
    public function coin() {
        return $this->hasMany(Coin::class);
    }

    protected function displayCoin(): Attribute {
        return Attribute::make(get: fn() => Coin::firstWhere('symbol', $this->symbol));
    }
}
