<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Investment extends Model
{
    use HasFactory;
    protected $guarded  = ['id'];

    protected $casts = [
        'is_active' => 'boolean',
        'started_at' => 'datetime',
        'expires_at' => 'datetime',
        'next_return' => 'datetime',
    ];

    public function plan() {
        return $this->belongsTo(Plan::class);
    }

    public function user() {
        return $this->belongsTo(user::class);
    }

    protected function coin(): Attribute {
        return Attribute::make(fn() => $this->plan->coin);
    }

    public static function active() {
        return static::where('is_active', true);
    }

    public function earnings() {
        return $this->hasMany(Earning::class);
    }

    protected function fullAmount(): Attribute {
        return Attribute::make(fn() => number_format($this->amount, 2).' '.$this->coin->symbol);
    }
}
