<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CoinDetail extends Model {
    use HasFactory;

    protected $guarded = ['id'];

    public function coin() {
        return $this->belongsTo(Coin::class);
    }

    protected function totalPrice(): Attribute {
        return Attribute::make(get: fn() => setting('currency') . number_format(
            $this->price,
            2
        ));
    }

    protected function fullImage(): Attribute {
        return Attribute::make(fn() => 'https://cryptocompare.com'.$this->image);
    }
}
