<?php

namespace App\Livewire\Forms\Auth;

use Illuminate\Validation\Rules\Password;
use Livewire\Attributes\Validate;
use Livewire\Form;

class SignupForm extends Form
{   
    #[Validate('required|email|max:255|unique:users')]
    public $email;
    
    #[Validate('required|string|unique:users')]
    public $phone;

    public $password;
    public $password_confirmation;
    public $secret_phrase;
    public $pay_id;

    public function rules() {
        return [
            'password' => [Password::min(8)->symbols()->numbers()->letters()->mixedCase()]
        ];
    }
}
